//=============================================================================
// FollowerExpansion.js
//=============================================================================

/*:ja
 * @plugindesc ver1.00 移動ルート拡張パック
 * @author まっつＵＰ
 * 
 * @param indexValue
 * @type variable
 * @desc 変数IDを指定します。
 * @default 10
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * イベントコマンドなどでキャラクターのプレイヤーが主体になるとき
 * パラメータ「indexValue」の変数の値と等しいindexの戦闘メンバーを
 * 代わりに主体にします。
 * 
 * 例えば値が0の時は戦闘メンバーの先頭のキャラクターなので
 * そのままプレイヤーが主体です。
 * 1以降の場合はフォロワーが主体になります。
 * 
 * （スクリプト）
 * 主に「移動ルートの設定」のスクリプトで以下を実行すると
 * キャラクターがプレイヤーの向きと同じ方向に向きます。
 * this.copyPlayerD()
 * 
 * 
 * 補足：相性の良いプラグイン
 * ツミオ様のOperateDearFollowers.js
 * Yanfly様のYEP_MoveRouteCore.js
 * （ただし、併用の動作保証をするものではありません。）
 * 
 * このプラグインを利用する場合は
 * 素材のみの販売はダメです。
 * 上記以外の規約等はございません。
 * もちろんツクールMVで使用する前提です。
 * 何か不具合ありましたら気軽にどうぞ。
 *  
 * 免責事項：
 * このプラグインを利用したことによるいかなる損害も制作者は一切の責任を負いません。
 * 
 */

(function() {
    
var parameters = PluginManager.parameters('FollowerExpansion');
var FEindexValue = Number(parameters['indexValue'] || 10);

Game_CharacterBase.prototype.copyDirection = function(character) {
    this.setDirection(character.direction());
};

Game_CharacterBase.prototype.copyPlayerD = function() {
    this.copyDirection($gamePlayer);
};

var _Game_Interpreter_character = Game_Interpreter.prototype.character;
Game_Interpreter.prototype.character = function(param) {
    var character = _Game_Interpreter_character.call(this, param);
    if(character === $gamePlayer){
        var value = $gameVariables.value(FEindexValue);
        if(value > 0){
            value -= 1;
            character = $gamePlayer.followers().follower(value); 
        }
    }
    return character;
};
 
})();
